/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.sog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JDesktopPane;
import javax.swing.JFileChooser;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import jsky.coords.CoordinateConverter;
import jsky.coords.WorldCoordinateConverter;
import jsky.image.ImageProcessor;
import jsky.image.fits.codec.FITSImage;
import jsky.image.gui.DivaMainImageDisplay;
import jsky.image.gui.ImageHistoryItem;
import jsky.navigator.NavigatorImageDisplay;
import jsky.util.FileUtil;
import jsky.util.gui.DialogUtil;
import nom.tam.fits.Header;
import nom.tam.util.Cursor;
import org.w3c.dom.Element;
import uk.ac.starlink.ast.AstException;
import uk.ac.starlink.ast.AstObject;
import uk.ac.starlink.ast.AstPackage;
import uk.ac.starlink.ast.FitsChan;
import uk.ac.starlink.ast.Frame;
import uk.ac.starlink.ast.FrameSet;
import uk.ac.starlink.ast.Plot;
import uk.ac.starlink.ast.gui.AbstractPlotControlsModel;
import uk.ac.starlink.ast.gui.GraphicsHints;
import uk.ac.starlink.ast.gui.GraphicsHintsControls;
import uk.ac.starlink.ast.gui.PlotConfiguration;
import uk.ac.starlink.ast.gui.PlotConfigurator;
import uk.ac.starlink.ast.gui.PlotController;
import uk.ac.starlink.ast.gui.PlotControls;
import uk.ac.starlink.jaiutil.HDXImage;
import uk.ac.starlink.jaiutil.HDXImageProcessor;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.ndx.Ndxs;
import uk.ac.starlink.sog.AstTransform;
import uk.ac.starlink.sog.SOGNavigatorImageDisplayFrame;
import uk.ac.starlink.sog.SOGNavigatorImageDisplayInternalFrame;
import uk.ac.starlink.sog.SOGTransferHandler;
import uk.ac.starlink.sog.photom.AperturePhotometryFrame;
import uk.ac.starlink.sog.photom.SOGCanvasDraw;
import uk.ac.starlink.util.gui.BasicFileChooser;
import uk.ac.starlink.util.gui.BasicFileFilter;
import uk.ac.starlink.util.gui.StoreConfiguration;

public class SOGNavigatorImageDisplay
extends NavigatorImageDisplay
implements PlotController {
    protected HDXImage hdxImage = null;
    protected boolean drawGrid = false;
    private int counter = 0;
    protected SOGCanvasDraw sogCanvasDraw = null;
    private boolean ndxLoading = false;
    private static boolean photomEnabled = false;
    private AbstractAction gridAction = new AbstractAction("Grid"){

        public void actionPerformed(ActionEvent evt) {
            AbstractButton b = (AbstractButton)evt.getSource();
            if (b.isSelected()) {
                SOGNavigatorImageDisplay.this.showGridControls();
            } else {
                SOGNavigatorImageDisplay.this.withdrawGridControls();
            }
        }
    };
    protected PlotConfigurator plotConfigurator = null;
    protected PlotConfiguration plotConfiguration = null;
    protected GraphicsHints graphicsHints = new GraphicsHints();
    protected Plot astPlot = null;
    private boolean doExit = true;
    private AbstractAction photometryAction = new AbstractAction("Photometry"){

        public void actionPerformed(ActionEvent evt) {
            AbstractButton b = (AbstractButton)evt.getSource();
            if (b.isSelected()) {
                SOGNavigatorImageDisplay.this.showPhotomControls();
            } else {
                SOGNavigatorImageDisplay.this.withdrawPhotomControls();
            }
        }
    };
    private AperturePhotometryFrame photometryWindow = null;
    private JFileChooser fileChooser = null;

    public SOGNavigatorImageDisplay(Component parent) {
        super(parent, (ImageProcessor)new HDXImageProcessor());
        this.sogCanvasDraw = new SOGCanvasDraw((DivaMainImageDisplay)this);
        this.setCanvasDraw(this.sogCanvasDraw);
        this.setTransferHandler(new SOGTransferHandler(this));
    }

    public Component newWindow() {
        JDesktopPane desktop = this.getDesktop();
        if (desktop != null) {
            SOGNavigatorImageDisplayInternalFrame f = new SOGNavigatorImageDisplayInternalFrame(desktop);
            f.getImageDisplayControl().getImageDisplay().setTitle(this.getTitle());
            f.setVisible(true);
            desktop.add((Component)((Object)f), JLayeredPane.DEFAULT_LAYER);
            desktop.moveToFront((Component)((Object)f));
            f.setVisible(true);
            return f;
        }
        SOGNavigatorImageDisplayFrame f = new SOGNavigatorImageDisplayFrame();
        f.getImageDisplayControl().getImageDisplay().setTitle(this.getTitle());
        f.setVisible(true);
        return f;
    }

    public void setFilename(String fileOrUrl) {
        try {
            this.setFilename(fileOrUrl, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setFilename(String fileOrUrl, boolean handle) throws Exception {
        block21: {
            if (fileOrUrl.startsWith("http:")) {
                this.setURL(FileUtil.makeURL(null, (String)fileOrUrl));
                return;
            }
            if (!this.checkSave()) {
                return;
            }
            this.addToHistory();
            this._filename = fileOrUrl;
            this._url = this._origURL = FileUtil.makeURL(null, (String)fileOrUrl);
            FITSImage fitsImage = this.getFitsImage();
            if (fitsImage != null) {
                fitsImage.close();
                fitsImage.clearTileCache();
                fitsImage = null;
            }
            if (this.hdxImage != null) {
                try {
                    this.hdxImage.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.hdxImage.clearTileCache();
                this.hdxImage = null;
            }
            if (this.isJAIImageType(this._filename)) {
                try {
                    this.setImage((PlanarImage)JAI.create((String)"fileload", (Object)this._filename));
                }
                catch (Exception exception) {
                    this._filename = null;
                    this._origURL = null;
                    this._url = null;
                    this.clear();
                    if (handle) {
                        DialogUtil.error((Exception)exception);
                    }
                    throw exception;
                }
            } else if (this._filename.endsWith("xml") || this._filename.endsWith("sdf")) {
                System.out.println("Loading NDX: " + this._filename);
                try {
                    this.hdxImage = new HDXImage(this._filename);
                    this.initHDXImage(this.hdxImage);
                    this.getImageProcessor().setInvertedYAxis(false);
                    this.setImage(PlanarImage.wrapRenderedImage((RenderedImage)this.hdxImage));
                }
                catch (IOException exception) {
                    this._filename = null;
                    this._origURL = null;
                    this._url = null;
                    this.clear();
                    if (handle) {
                        DialogUtil.error((Exception)exception);
                    }
                    throw exception;
                }
            } else {
                try {
                    fitsImage = new FITSImage(this._filename);
                    this.initFITSImage(fitsImage);
                    this.setImage(fitsImage);
                }
                catch (Exception e) {
                    try {
                        this.setImage((PlanarImage)JAI.create((String)"fileload", (Object)this._filename));
                    }
                    catch (Exception exception) {
                        this._filename = null;
                        this._origURL = null;
                        this._url = null;
                        this.clear();
                        if (handle) {
                            DialogUtil.error((Exception)e);
                            break block21;
                        }
                        throw e;
                    }
                }
            }
        }
        this.updateTitle();
    }

    public void setHDXImage(HDXImage hdxImage) {
        if (!this.checkSave()) {
            return;
        }
        this.addToHistory();
        try {
            PlanarImage im = PlanarImage.wrapRenderedImage((RenderedImage)hdxImage);
            this.ndxLoading = true;
            this.setImage(im);
            this.ndxLoading = false;
        }
        catch (Exception e) {
            DialogUtil.error((Exception)e);
            this.clear();
        }
        this.updateTitle();
        ImageProcessor ip = this.getImageProcessor();
        ip.autoSetCutLevels(this.getVisibleArea());
        ip.update();
    }

    public void setRemoteNDX(Element element) throws IOException {
        HDXImage hdxImage = new HDXImage(element, 0);
        this.setHDXImage(hdxImage);
    }

    public void setNDX(Element element) {
        try {
            HDXImage hdxImage = new HDXImage(element, 0);
            this.setHDXImage(hdxImage);
        }
        catch (IOException e) {
            DialogUtil.error((Exception)e);
            this.clear();
        }
    }

    protected void updateEnabledStates() {
        super.updateEnabledStates();
        if (this.ndxLoading) {
            this.getCutLevelsAction().setEnabled(true);
            this.getColorsAction().setEnabled(true);
        }
        if (this.gridAction != null) {
            this.gridAction.setEnabled(this.getCutLevelsAction().isEnabled());
        }
    }

    protected void newImage(boolean before) {
        Object o;
        PlanarImage im;
        if (before) {
            if (this.hdxImage != null) {
                this.hdxImage.clearTileCache();
            }
            this.hdxImage = null;
            this.setWCS(null);
        } else if (this.getFitsImage() == null && (im = this.getImage()) != null && (o = im.getProperty("#ndx_image")) != null && o instanceof HDXImage) {
            this.hdxImage = (HDXImage)o;
            this.initWCS();
        }
        super.newImage(before);
    }

    protected void initHDXImage(HDXImage hdxImage) throws IOException {
        ImageHistoryItem hi = this.getImageHistoryItem(new File(this._filename));
        float scale = hi != null ? hi.getScale() : this.getScale();
        if (scale != 1.0f) {
            hdxImage.setScale(scale);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void initWCS() {
        if (this.getFitsImage() != null) {
            if (!AstPackage.isAvailable()) {
                super.initWCS();
                return;
            }
            try {
                this.initWCSFromFits();
                return;
            }
            catch (AstException e) {
                System.out.println(e.getMessage());
                super.initWCS();
                return;
            }
        }
        if (this.hdxImage == null) {
            return;
        }
        if (this.getWCS() != null) {
            return;
        }
        Ndx ndx = this.hdxImage.getCurrentNDX();
        if (!AstPackage.isAvailable()) {
            System.err.println("No WCS support available");
            this.setWCS(null);
            return;
        }
        try {
            FrameSet frameSet = Ndxs.getAst((Ndx)ndx);
            if (frameSet != null) {
                this.setWCS(new AstTransform(frameSet, this.getImageWidth(), this.getImageHeight()));
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            this.setWCS(null);
            return;
        }
        if (this.getWCS().isWCS()) return;
        this.setWCS(null);
    }

    protected void initWCSFromFits() throws AstException {
        Header header = this.getFitsImage().getHeader();
        Cursor iter = header.iterator();
        FitsChan fitschan = new FitsChan();
        while (iter.hasNext()) {
            try {
                fitschan.putFits(iter.next().toString(), false);
            }
            catch (AstException e) {
                System.out.println(e.getMessage());
            }
        }
        fitschan.setCard(0);
        AstObject astObject = fitschan.read();
        if (astObject == null || !(astObject instanceof FrameSet)) {
            throw new AstException("Failed to read FITS WCS using JNIAST");
        }
        this.setWCS(new AstTransform((FrameSet)astObject, this.getImageWidth(), this.getImageHeight()));
    }

    public Ndx getCurrentNdx() {
        return this.hdxImage.getCurrentNDX();
    }

    public AbstractAction getGridAction() {
        return this.gridAction;
    }

    protected void showGridControls() {
        if (this.plotConfiguration == null) {
            if (AstPackage.isAvailable()) {
                this.plotConfiguration = new PlotConfiguration();
            } else {
                System.err.println("Cannot display WCS grids, no AST support");
                return;
            }
        }
        if (this.plotConfigurator == null) {
            this.plotConfigurator = new PlotConfigurator("Grid Overlay Configuration", (PlotController)this, this.plotConfiguration, "jsky", "PlotConfig.xml");
            this.plotConfiguration.add((AbstractPlotControlsModel)this.graphicsHints);
            this.plotConfigurator.addExtraControls((PlotControls)new GraphicsHintsControls((AbstractPlotControlsModel)this.graphicsHints), true);
            InputStream defaultConfig = ((Object)((Object)this)).getClass().getResourceAsStream("defaultgrid.xml");
            StoreConfiguration store = new StoreConfiguration(defaultConfig);
            Element defaultElement = store.getState(0);
            this.plotConfigurator.restoreState(defaultElement);
            this.plotConfigurator.reset();
            try {
                defaultConfig.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.plotConfigurator.setVisible(true);
    }

    public void withdrawGridControls() {
        this.drawGrid = false;
        if (this.astPlot != null) {
            this.astPlot.clear();
            this.repaint();
        }
        if (this.plotConfigurator != null) {
            this.plotConfigurator.setVisible(false);
        }
    }

    public void doPlot() {
        WorldCoordinateConverter transform = this.getWCS();
        if (transform == null || !this.getWCS().isWCS() || !(transform instanceof AstTransform)) {
            this.astPlot = null;
            return;
        }
        CoordinateConverter cc = this.getCoordinateConverter();
        FrameSet frameSet = ((AstTransform)transform).getFrameSet();
        double[] canvasbox = new double[4];
        Point2D.Double p = new Point2D.Double();
        p.setLocation(1.0, 1.0);
        cc.imageToScreenCoords(p, false);
        canvasbox[0] = p.x;
        canvasbox[1] = p.y;
        p.setLocation(this.getImageWidth(), this.getImageHeight());
        cc.imageToScreenCoords(p, false);
        canvasbox[2] = p.x;
        canvasbox[3] = p.y;
        int xo = (int)Math.min(canvasbox[0], canvasbox[2]);
        int yo = (int)Math.min(canvasbox[1], canvasbox[3]);
        int dw = (int)Math.max(canvasbox[0], canvasbox[2]) - xo;
        int dh = (int)Math.max(canvasbox[1], canvasbox[3]) - yo;
        Rectangle graphRect = new Rectangle(xo, yo, dw, dh);
        double[] basebox = new double[4];
        p = new Point2D.Double();
        p.setLocation(xo, yo + dh);
        cc.screenToImageCoords(p, false);
        basebox[0] = p.x;
        basebox[1] = p.y;
        p.setLocation(xo + dw, yo);
        cc.screenToImageCoords(p, false);
        basebox[2] = p.x;
        basebox[3] = p.y;
        if (this.astPlot != null) {
            this.astPlot.clear();
        }
        this.astPlot = new Plot((Frame)frameSet, (Rectangle2D)graphRect, basebox);
        String options = this.plotConfiguration.getAst();
        this.astPlot.set(options);
        this.astPlot.grid();
    }

    public synchronized void paintLayer(Graphics2D g2D, Rectangle2D region) {
        super.paintLayer(g2D, region);
        if (this.drawGrid) {
            this.doPlot();
            if (this.astPlot != null) {
                this.graphicsHints.applyRenderingHints(g2D);
                this.astPlot.paint((Graphics)g2D);
            }
        }
    }

    public void exit() {
        if (this.doExit) {
            super.exit();
        } else {
            Window w = SwingUtilities.getWindowAncestor((Component)((Object)this));
            if (w != null) {
                w.setVisible(false);
            } else {
                this.setVisible(false);
            }
        }
    }

    public void setDoExit(boolean doExit) {
        this.doExit = doExit;
    }

    public boolean isDoExit() {
        return this.doExit;
    }

    public void updatePlot() {
        this.drawGrid = true;
        this.repaint();
    }

    public void setPlotColour(Color color) {
        this.setBackground(color);
    }

    public Color getPlotColour() {
        return this.getBackground();
    }

    public Frame getPlotCurrentFrame() {
        WorldCoordinateConverter transform = this.getWCS();
        if (transform == null || !this.getWCS().isWCS() || !(transform instanceof AstTransform)) {
            return new Frame(2);
        }
        return ((AstTransform)transform).getFrameSet();
    }

    public AbstractAction getPhotomAction() {
        if (photomEnabled) {
            return this.photometryAction;
        }
        return null;
    }

    public void withdrawPhotomControls() {
        if (this.photometryWindow != null) {
            this.photometryWindow.setVisible(false);
        }
    }

    protected void showPhotomControls() {
        if (this.photometryWindow == null) {
            this.photometryWindow = new AperturePhotometryFrame(this);
        }
        this.photometryWindow.setVisible(true);
    }

    public void setScale(float scale) {
        super.setScale(scale);
        if (this.hdxImage != null) {
            boolean needsUpdate = false;
            try {
                needsUpdate = this.hdxImage.setScale(scale);
                this.setPrescaled(this.hdxImage.getSubsample() != 1);
            }
            catch (IOException e) {
                DialogUtil.error((Exception)e);
            }
            if (!needsUpdate && scale == this.getScale()) {
                return;
            }
            if (needsUpdate) {
                ImageProcessor ip = this.getImageProcessor();
                ip.setSourceImage(PlanarImage.wrapRenderedImage((RenderedImage)this.hdxImage), ip);
                ip.update();
            }
        }
    }

    protected double _getPixelValue(PlanarImage im, int ix, int iy, int w, int h, int band) {
        if (this.hdxImage == null) {
            return super._getPixelValue(im, ix, iy, w, h, band);
        }
        int subsample = this.hdxImage.getSubsample();
        ix /= subsample;
        iy /= subsample;
        if (!this.getImageProcessor().isInvertedYAxis()) {
            iy = h - 1 - iy;
        }
        if (ix < 0 || ix >= w || iy < 0 || iy >= h) {
            return 0.0;
        }
        int x = (int)((double)ix / (double)this.hdxImage.getTileWidth());
        int y = (int)((double)iy / (double)this.hdxImage.getTileHeight());
        if (x < 0 || y < 0) {
            return 0.0;
        }
        Raster tile = im.getTile(x, y);
        if (tile != null) {
            try {
                return tile.getSampleDouble(ix, iy, band);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return 0.0;
    }

    public int getImageWidth() {
        if (this.hdxImage == null) {
            return super.getImageWidth();
        }
        return this.hdxImage.getRealWidth();
    }

    public int getImageHeight() {
        if (this.hdxImage == null) {
            return super.getImageHeight();
        }
        return this.hdxImage.getRealHeight();
    }

    public void open() {
        if (this.fileChooser == null) {
            this.fileChooser = SOGNavigatorImageDisplay.makeImageFileChooser();
            this.setFileChooser(this.fileChooser);
        }
        super.open();
    }

    public static JFileChooser makeImageFileChooser() {
        JFileChooser plainChooser = NavigatorImageDisplay.makeImageFileChooser();
        FileFilter currentFilter = plainChooser.getFileFilter();
        FileFilter[] defaultFilters = plainChooser.getChoosableFileFilters();
        BasicFileChooser chooser = new BasicFileChooser();
        for (int i = 0; i < defaultFilters.length; ++i) {
            chooser.setFileFilter(defaultFilters[i]);
        }
        BasicFileFilter hdsFilter = new BasicFileFilter("sdf", "HDS container files");
        chooser.addChoosableFileFilter((FileFilter)hdsFilter);
        BasicFileFilter hdxFilter = new BasicFileFilter("xml", "HDX/NDX XML files");
        chooser.addChoosableFileFilter((FileFilter)hdxFilter);
        chooser.setFileFilter(currentFilter);
        return chooser;
    }

    public static void setPhotomEnabled(boolean photomEnabled) {
        SOGNavigatorImageDisplay.photomEnabled = photomEnabled;
    }
}

