/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.sog;

import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JToggleButton;
import jsky.navigator.NavigatorImageDisplay;
import jsky.navigator.NavigatorImageDisplayToolBar;
import uk.ac.starlink.sog.SOGNavigatorImageDisplay;

public class SOGNavigatorImageDisplayToolBar
extends NavigatorImageDisplayToolBar {
    protected JToggleButton gridButton;
    protected JToggleButton photomButton;

    public SOGNavigatorImageDisplayToolBar(NavigatorImageDisplay imageDisplay) {
        super(imageDisplay);
    }

    protected void addToolBarItems() {
        super.addToolBarItems();
        this.addSeparator();
        this.add(this.makeGridButton());
        JToggleButton b = this.makePhotomButton();
        if (b != null) {
            this.add(b);
        }
    }

    protected JToggleButton makeGridButton() {
        if (this.gridButton == null) {
            this.gridButton = this.makeToggleButton("display an astrometric grid overlay", ((SOGNavigatorImageDisplay)this.imageDisplay).getGridAction());
        }
        this.updateButton(this.gridButton, "Grid", new ImageIcon(((Object)((Object)this)).getClass().getResource("images/grid.gif")));
        return this.gridButton;
    }

    protected JToggleButton makePhotomButton() {
        AbstractAction photomAction;
        if (this.photomButton == null && (photomAction = ((SOGNavigatorImageDisplay)this.imageDisplay).getPhotomAction()) != null) {
            this.photomButton = this.makeToggleButton("perform simple aperture photometry", photomAction);
        }
        if (this.photomButton != null) {
            ImageIcon icon = new ImageIcon(((Object)((Object)this)).getClass().getResource("images/aperture_photom.gif"));
            this.updateButton(this.photomButton, "Photometry", icon);
        }
        return this.photomButton;
    }

    public void update() {
        super.update();
        this.makeGridButton();
        this.makePhotomButton();
    }
}

