/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.sog.photom;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.ac.starlink.sog.photom.AnnulusPhotom;
import uk.ac.starlink.sog.photom.PhotomList;

public class ApertureController
extends JPanel
implements ChangeListener {
    private PhotomList photomList;
    private GridBagConstraints gbc = new GridBagConstraints();
    protected Insets labelInsets = new Insets(10, 5, 5, 10);
    private JLabel identifier = new JLabel();
    private JLabel xcoord = new JLabel();
    private JLabel ycoord = new JLabel();
    private JLabel mag = new JLabel();
    private JLabel magerr = new JLabel();
    private JLabel sum = new JLabel();
    private JLabel status = new JLabel();
    private JLabel sky = new JLabel();
    private JLabel shape = new JLabel();
    private JLabel semimajor = new JLabel();
    private JLabel semiminor = new JLabel();
    private JLabel angle = new JLabel();
    private SpinnerNumberModel innerscaleModel = null;
    private SpinnerNumberModel outerscaleModel = null;

    public ApertureController(PhotomList photomList) {
        this.photomList = photomList;
        this.initUI();
        photomList.addChangeListener(this);
    }

    private void initUI() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder("Current aperture details"));
        this.innerscaleModel = new SpinnerNumberModel(2.0, 1.0, 20.0, 0.05);
        JSpinner innerscale = new JSpinner(this.innerscaleModel);
        innerscale.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ApertureController.this.matchInnerscale();
            }
        });
        this.outerscaleModel = new SpinnerNumberModel(3.0, 1.0, 20.0, 0.05);
        JSpinner outerscale = new JSpinner(this.outerscaleModel);
        outerscale.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ApertureController.this.matchOuterscale();
            }
        });
        this.addLabel("Identifier:", 0);
        this.addLabel("X coordinate:", 1);
        this.addLabel("Y coordinate:", 2);
        this.addLabel("Magnitude:", 3);
        this.addLabel("Magnitude error:", 4);
        this.addLabel("Sum in aperture:", 5);
        this.addLabel("Sky:", 6);
        this.addLabel("Shape:", 7);
        this.addLabel("Status:", 8);
        this.addLabel("Semimajor axis:", 9);
        this.addLabel("Semiminor axis:", 10);
        this.addLabel("Position angle:", 11);
        this.addLabel("Annulus inner scale:", 12);
        this.addLabel("Annulus outer scale:", 13);
        this.gbc.insets = new Insets(0, 0, 0, 0);
        this.gbc.anchor = 17;
        this.gbc.weighty = 0.0;
        this.gbc.weightx = 1.0;
        this.gbc.gridx = 1;
        int row = 0;
        this.gbc.gridy = row++;
        this.gbc.fill = 0;
        this.add((Component)this.identifier, this.gbc);
        this.gbc.gridy = row++;
        this.gbc.fill = 0;
        this.add((Component)this.xcoord, this.gbc);
        this.gbc.gridy = row++;
        this.gbc.fill = 0;
        this.add((Component)this.ycoord, this.gbc);
        this.gbc.gridy = row++;
        this.gbc.fill = 0;
        this.add((Component)this.mag, this.gbc);
        this.gbc.gridy = row++;
        this.gbc.fill = 0;
        this.add((Component)this.magerr, this.gbc);
        this.gbc.gridy = row++;
        this.gbc.fill = 0;
        this.add((Component)this.sum, this.gbc);
        this.gbc.gridy = row++;
        this.gbc.fill = 0;
        this.add((Component)this.sky, this.gbc);
        this.gbc.gridy = row++;
        this.gbc.fill = 0;
        this.add((Component)this.shape, this.gbc);
        this.gbc.gridy = row++;
        this.gbc.fill = 0;
        this.add((Component)this.status, this.gbc);
        this.gbc.gridy = row++;
        this.gbc.fill = 0;
        this.add((Component)this.semimajor, this.gbc);
        this.gbc.gridy = row++;
        this.gbc.fill = 0;
        this.add((Component)this.semiminor, this.gbc);
        this.gbc.gridy = row++;
        this.gbc.fill = 0;
        this.add((Component)this.angle, this.gbc);
        this.gbc.gridy = row++;
        this.gbc.fill = 0;
        this.add((Component)innerscale, this.gbc);
        this.gbc.gridy = row++;
        this.gbc.fill = 0;
        this.add((Component)outerscale, this.gbc);
    }

    private void addLabel(String text, int row) {
        JLabel label = new JLabel(text);
        this.gbc.gridx = 0;
        this.gbc.gridy = row;
        this.gbc.fill = 0;
        this.gbc.anchor = 13;
        this.gbc.gridwidth = 1;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.insets = this.labelInsets;
        this.add((Component)label, this.gbc);
    }

    protected void updateView() {
        AnnulusPhotom current = (AnnulusPhotom)this.photomList.getCurrent();
        if (current == null) {
            this.reset();
        } else {
            this.identifier.setText(Integer.toString(current.getIdent()));
            this.xcoord.setText(Double.toString(current.getXcoord()));
            this.ycoord.setText(Double.toString(current.getYcoord()));
            this.mag.setText(Double.toString(current.getMagnitude()));
            this.magerr.setText(Double.toString(current.getMagnitudeError()));
            this.sum.setText(Double.toString(current.getSignal()));
            this.sky.setText(Double.toString(current.getSky()));
            this.shape.setText(Double.toString(current.getShape()));
            this.status.setText(current.getStatus());
            this.semimajor.setText(Double.toString(current.getSemimajor()));
            this.semiminor.setText(Double.toString(current.getSemiminor()));
            this.angle.setText(Double.toString(current.getAngle()));
            this.innerscaleModel.setValue(new Double(current.getInnerscale()));
            this.outerscaleModel.setValue(new Double(current.getOuterscale()));
        }
    }

    public void reset() {
        this.identifier.setText("");
        this.xcoord.setText("");
        this.ycoord.setText("");
        this.mag.setText("");
        this.magerr.setText("");
        this.sum.setText("");
        this.sky.setText("");
        this.shape.setText("");
        this.status.setText("?");
        this.semimajor.setText("");
        this.semiminor.setText("");
        this.angle.setText("");
        this.innerscaleModel.setValue(new Double(2.0));
        this.outerscaleModel.setValue(new Double(3.0));
    }

    protected void matchInnerscale() {
        AnnulusPhotom current = (AnnulusPhotom)this.photomList.getCurrent();
        if (current != null) {
            current.setInnerscale(this.innerscaleModel.getNumber().doubleValue());
        }
    }

    protected void matchOuterscale() {
        AnnulusPhotom current = (AnnulusPhotom)this.photomList.getCurrent();
        if (current != null) {
            current.setOuterscale(this.outerscaleModel.getNumber().doubleValue());
        }
    }

    public void stateChanged(ChangeEvent e) {
        this.updateView();
    }
}

