/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.sog.photom;

import diva.canvas.interactor.Interactor;
import diva.canvas.interactor.SelectionInteractor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jsky.coords.CoordinateConverter;
import jsky.coords.WorldCoordinateConverter;
import jsky.graphics.CanvasFigure;
import jsky.graphics.CanvasFigureEvent;
import jsky.graphics.CanvasFigureListener;
import jsky.image.graphics.DivaImageGraphics;
import jsky.util.gui.DialogUtil;
import uk.ac.starlink.sog.AstTransform;
import uk.ac.starlink.sog.ExceptionDialog;
import uk.ac.starlink.sog.SOGNavigatorImageDisplay;
import uk.ac.starlink.sog.photom.AnnulusFigure;
import uk.ac.starlink.sog.photom.AnnulusPhotom;
import uk.ac.starlink.sog.photom.ApertureController;
import uk.ac.starlink.sog.photom.PhotomList;
import uk.ac.starlink.sog.photom.PhotomListTableModel;
import uk.ac.starlink.sog.photom.PhotometryGlobals;
import uk.ac.starlink.sog.photom.PhotometryGlobalsView;
import uk.ac.starlink.sog.photom.PhotometryWorker;
import uk.ac.starlink.sog.photom.SOGCanvasDraw;

public class AperturePhotometry
extends JPanel
implements CanvasFigureListener,
ChangeListener {
    private Component parent;
    private SOGNavigatorImageDisplay imageDisplay;
    private PhotomList photomList = new PhotomList();
    private PhotometryGlobals globals = new PhotometryGlobals();
    private SOGCanvasDraw sogCanvasDraw;
    private ArrayList figureList = new ArrayList();
    private boolean creationStarted = false;

    public AperturePhotometry(Component parent, SOGNavigatorImageDisplay imageDisplay) {
        this.parent = parent;
        this.imageDisplay = imageDisplay;
        this.setLayout(new BorderLayout());
        this.add((Component)this.makeViewPane(), "Center");
        this.add((Component)this.makeButtonPanel(), "South");
        this.sogCanvasDraw = (SOGCanvasDraw)imageDisplay.getCanvasDraw();
        this.sogCanvasDraw.addFinishedListener(this);
    }

    private JTabbedPane makeViewPane() {
        JTabbedPane pane = new JTabbedPane();
        ApertureController controller = new ApertureController(this.photomList);
        pane.add((Component)controller, "Aperture");
        PhotometryGlobalsView globalsView = new PhotometryGlobalsView(this.globals);
        pane.add((Component)globalsView, "Parameters");
        JTable table = new JTable(new PhotomListTableModel(this.photomList));
        table.setAutoResizeMode(0);
        JScrollPane scrollPane = new JScrollPane(table);
        pane.add((Component)scrollPane, "Results");
        this.photomList.addChangeListener(this);
        return pane;
    }

    private JPanel makeButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(2));
        JButton addButton = new JButton("Add Aperture");
        panel.add(addButton);
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                AperturePhotometry.this.addAperture();
            }
        });
        JButton measureButton = new JButton("Calculate Results");
        panel.add(measureButton);
        measureButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AperturePhotometry.this.doCalculations();
            }
        });
        JButton closeButton = new JButton("Close");
        panel.add(closeButton);
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                AperturePhotometry.this.close();
            }
        });
        return panel;
    }

    protected void close() {
        if (this.parent != null) {
            this.parent.setVisible(false);
        }
    }

    public PhotomList getPhotomList() {
        return this.photomList;
    }

    public PhotometryGlobals getGlobals() {
        return this.globals;
    }

    public ArrayList getFigureList() {
        return this.figureList;
    }

    public void addAperture() {
        this.sogCanvasDraw.setDrawingMode(SOGCanvasDraw.ANNULAR_CIRCLE);
        this.creationStarted = true;
    }

    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source instanceof PhotomList) {
            if (!this.creationStarted) {
                this.updateFigureList();
            }
        } else if (source instanceof AnnulusFigure) {
            CanvasFigure figure = (CanvasFigure)source;
            AnnulusPhotom annulusPhotom = null;
            if (this.creationStarted) {
                figure.addCanvasFigureListener((CanvasFigureListener)this);
                annulusPhotom = new AnnulusPhotom();
                this.photomList.add(annulusPhotom);
                this.figureList.add(figure);
                figure.setClientData((Object)annulusPhotom);
                this.creationStarted = false;
            } else {
                annulusPhotom = this.extractAperture((AnnulusFigure)figure);
            }
            this.matchModelToFigure((AnnulusFigure)figure, annulusPhotom, true);
        }
    }

    protected void setupFigure(CanvasFigure figure, AnnulusPhotom annulusPhotom) {
        figure.removeCanvasFigureListener((CanvasFigureListener)this);
        figure.addCanvasFigureListener((CanvasFigureListener)this);
        figure.setClientData((Object)annulusPhotom);
    }

    public void remove(int index) {
        this.removeFigure(index);
        this.photomList.remove(index);
    }

    protected void removeFigure(int index) {
        AnnulusFigure figure = (AnnulusFigure)((Object)this.figureList.get(index));
        this.sogCanvasDraw.removeFigure((CanvasFigure)figure);
        this.figureList.remove(index);
    }

    public void figureSelected(CanvasFigureEvent e) {
        AnnulusPhotom aperture = this.extractAperture(e);
        if (aperture != null) {
            this.makeCurrent(aperture);
        }
    }

    protected AnnulusPhotom extractAperture(CanvasFigureEvent e) {
        AnnulusFigure figure = this.extractFigure(e);
        if (figure != null) {
            return this.extractAperture(figure);
        }
        return null;
    }

    protected AnnulusPhotom extractAperture(AnnulusFigure figure) {
        if (figure.getClientData() instanceof AnnulusPhotom) {
            return (AnnulusPhotom)figure.getClientData();
        }
        return null;
    }

    protected AnnulusFigure extractFigure(CanvasFigureEvent e) {
        if (e.getSource() instanceof AnnulusFigure) {
            return (AnnulusFigure)((Object)e.getSource());
        }
        return null;
    }

    protected int makeCurrent(AnnulusPhotom aperture) {
        int index = this.photomList.indexOf(aperture);
        if (index != -1) {
            this.photomList.setCurrent(index);
        }
        return index;
    }

    public void figureDeselected(CanvasFigureEvent e) {
    }

    public void figureResized(CanvasFigureEvent e) {
        AnnulusPhotom aperture = this.extractAperture(e);
        if (aperture != null) {
            this.matchModelToFigure(this.extractFigure(e), aperture, true);
        }
    }

    protected void matchModelToFigure(AnnulusFigure figure, AnnulusPhotom model, boolean makeCurrent) {
        if (model != null && figure != null) {
            Point2D.Double cxy = figure.getPosition();
            double cr = figure.getRadius();
            Point2D.Double rad = new Point2D.Double(cr, cr);
            double cinner = figure.getInnerscale();
            double couter = figure.getOuterscale();
            CoordinateConverter cc = this.imageDisplay.getCoordinateConverter();
            cc.screenToImageCoords(cxy, false);
            cc.screenToImageCoords(rad, true);
            WorldCoordinateConverter wcc = this.imageDisplay.getWCS();
            if (wcc instanceof AstTransform) {
                AstTransform astWCS = (AstTransform)wcc;
                int current = astWCS.getCurrent();
                astWCS.setDomain("PIXEL");
                wcc.imageToWorldCoords(cxy, false);
                astWCS.setCurrent(current);
            } else {
                cxy.x -= 1.5;
                cxy.y -= 1.5;
            }
            model.setXcoord(cxy.x);
            model.setYcoord(cxy.y);
            model.setSemimajor(rad.x);
            model.setSemiminor(rad.y);
            model.setInnerscale(cinner);
            model.setOuterscale(couter);
            if (makeCurrent) {
                this.makeCurrent(model);
            }
        }
    }

    protected void matchFigureToModel(AnnulusPhotom model, AnnulusFigure figure, boolean makeCurrent) {
        if (model != null && figure != null) {
            Point2D.Double xy = new Point2D.Double(model.getXcoord(), model.getYcoord());
            double imrad = model.getSemimajor();
            Point2D.Double rad = new Point2D.Double(imrad, imrad);
            WorldCoordinateConverter wcc = this.imageDisplay.getWCS();
            if (wcc instanceof AstTransform) {
                AstTransform astWCS = (AstTransform)wcc;
                int current = astWCS.getCurrent();
                astWCS.setDomain("PIXEL");
                wcc.worldToImageCoords(xy, false);
                astWCS.setCurrent(current);
            } else {
                xy.x += 1.5;
                xy.y += 1.5;
            }
            CoordinateConverter cc = this.imageDisplay.getCoordinateConverter();
            cc.imageToScreenCoords(xy, false);
            cc.imageToScreenCoords(rad, true);
            figure.setPosition(xy);
            figure.setRadius(rad.x);
            figure.setInnerscale(model.getInnerscale());
            figure.setOuterscale(model.getOuterscale());
            if (makeCurrent) {
                this.makeCurrent(model);
            }
        }
    }

    public void figureMoved(CanvasFigureEvent e) {
        this.figureResized(e);
    }

    public void doCalculations() {
        if (this.photomList.size() > 0) {
            try {
                PhotometryWorker worker = new PhotometryWorker();
                worker.calculate(this.imageDisplay.getCurrentNdx(), this.photomList, this.globals, this);
            }
            catch (Exception e) {
                new ExceptionDialog(this, e);
            }
        } else {
            DialogUtil.error((String)"No apertures are defined");
        }
    }

    public void calculationsDone() {
        this.updateFigureList();
    }

    public void updateFigureList() {
        AnnulusFigure figure = null;
        AnnulusPhotom photom = null;
        Paint fill = this.sogCanvasDraw.getFill();
        Paint outline = this.sogCanvasDraw.getOutline();
        float lineWidth = this.sogCanvasDraw.getLineWidth();
        DivaImageGraphics canvasGraphics = (DivaImageGraphics)this.imageDisplay.getCanvasGraphics();
        SelectionInteractor interactor = canvasGraphics.getSelectionInteractor();
        for (int i = 0; i < this.photomList.size(); ++i) {
            figure = this.figureList.size() <= i ? new AnnulusFigure(10.0, fill, outline, lineWidth, (Interactor)interactor) : (AnnulusFigure)((Object)this.figureList.get(i));
            photom = (AnnulusPhotom)this.photomList.get(i);
            this.setupFigure((CanvasFigure)figure, photom);
            this.matchFigureToModel(photom, figure, false);
        }
        canvasGraphics.clearSelection();
        int index = this.photomList.indexOf(this.photomList.getCurrent());
        canvasGraphics.select((CanvasFigure)((AnnulusFigure)((Object)this.figureList.get(index))));
        if (this.figureList.size() > this.photomList.size()) {
            System.out.println("trimmed excess figures...");
            for (int i = this.figureList.size() - 1; i >= this.photomList.size(); --i) {
                this.removeFigure(i);
            }
        }
    }
}

