/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.sog.photom;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.ac.starlink.ast.gui.DecimalField;
import uk.ac.starlink.ast.gui.ScientificFormat;
import uk.ac.starlink.sog.photom.PhotometryGlobals;

public class PhotometryGlobalsView
extends JPanel
implements ChangeListener {
    private PhotometryGlobals model = null;
    private GridBagConstraints gbc = new GridBagConstraints();
    protected Insets labelInsets = new Insets(10, 5, 5, 10);
    private DecimalField zeroPoint = new DecimalField(50.0, 10, new ScientificFormat());
    private JCheckBox centroid = new JCheckBox();

    public PhotometryGlobalsView() {
        this(new PhotometryGlobals());
    }

    public PhotometryGlobalsView(PhotometryGlobals model) {
        this.initUI();
        this.setPhotometryGlobals(model);
    }

    private void initUI() {
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder("Global measurement parameters"));
        this.zeroPoint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PhotometryGlobalsView.this.matchZeroPoint();
            }
        });
        this.centroid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PhotometryGlobalsView.this.matchCentroid();
            }
        });
        this.addLabel("Zero point:", 0);
        this.addLabel("Centroid:", 1);
        this.gbc.insets = new Insets(0, 0, 0, 0);
        this.gbc.anchor = 17;
        this.gbc.weighty = 0.0;
        this.gbc.weightx = 1.0;
        this.gbc.gridx = 1;
        int row = 0;
        this.gbc.gridy = row++;
        this.gbc.fill = 0;
        this.add((Component)this.zeroPoint, this.gbc);
        this.gbc.gridy = row++;
        this.gbc.fill = 0;
        this.add((Component)this.centroid, this.gbc);
        Component filly2 = Box.createVerticalStrut(5);
        this.gbc.gridy = row++;
        this.gbc.weighty = 1.0;
        this.gbc.fill = 3;
        this.add(filly2, this.gbc);
    }

    private void addLabel(String text, int row) {
        JLabel label = new JLabel(text);
        this.gbc.gridx = 0;
        this.gbc.gridy = row;
        this.gbc.fill = 0;
        this.gbc.anchor = 13;
        this.gbc.gridwidth = 1;
        this.gbc.weightx = 0.0;
        this.gbc.weighty = 0.0;
        this.gbc.insets = this.labelInsets;
        this.add((Component)label, this.gbc);
    }

    protected void updateView() {
        this.zeroPoint.setDoubleValue(this.model.getZeroPoint());
        this.centroid.setSelected(this.model.getCentroid());
    }

    public void reset() {
        this.model.reset();
    }

    protected void matchZeroPoint() {
        this.model.setZeroPoint(this.zeroPoint.getDoubleValue());
    }

    protected void matchCentroid() {
        this.model.setCentroid(this.centroid.isSelected());
    }

    public void setPhotometryGlobals(PhotometryGlobals model) {
        this.model = model;
        this.updateView();
    }

    public PhotometryGlobals getPhotometryGlobals() {
        return this.model;
    }

    public void stateChanged(ChangeEvent e) {
        this.updateView();
    }
}

