/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.gui;

import edu.sdsc.grid.gui.MetaDataTableDisplay;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataTable;
import edu.sdsc.grid.io.srb.SRBException;
import edu.sdsc.grid.io.srb.SRBMetaDataRecordList;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.IOException;
import java.util.Date;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

class MetaDataDisplay
extends JPanel {
    static final int TEXT_PADDING = 3;
    static int TEST_ROWS = 5;
    GeneralFileSystem fileSystem;
    private MetaDataRecordList[] rl;
    private MetaDataTable table;
    private GeneralFile queryObj;
    private MetaDataCondition[] conditions;
    private MetaDataSelect[] selects;
    private JComboBox jComboBox1;
    private JPanel mainPanel;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JTree jTree1;
    private boolean action = false;
    private JButton jButton1;
    private JList jList1;
    boolean keyValue = true;
    static int fontPixelHeight = -1;
    static Font font;
    static FontMetrics fontMetrics;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$swing$JTable;

    public MetaDataDisplay(MetaDataRecordList metaDataRecordList) {
        this.rl = new MetaDataRecordList[1];
        this.rl[0] = metaDataRecordList;
        this.initComponents();
    }

    public MetaDataDisplay(MetaDataRecordList[] metaDataRecordListArray) {
        this.rl = metaDataRecordListArray;
        this.initComponents();
    }

    MetaDataDisplay(GeneralFile generalFile, MetaDataRecordList metaDataRecordList) {
        this.queryObj = generalFile;
        this.rl = new MetaDataRecordList[1];
        this.rl[0] = metaDataRecordList;
        this.initComponents();
    }

    MetaDataDisplay(GeneralFile generalFile, MetaDataRecordList[] metaDataRecordListArray) {
        this.queryObj = generalFile;
        this.rl = metaDataRecordListArray;
        this.initComponents();
    }

    public MetaDataDisplay(MetaDataTable metaDataTable) {
        this.table = metaDataTable;
        this.initComponents();
    }

    MetaDataDisplay(GeneralFile generalFile, MetaDataRecordList metaDataRecordList, String[] stringArray) {
        this.queryObj = generalFile;
        this.rl = new MetaDataRecordList[1];
        this.rl[0] = metaDataRecordList;
        this.action = true;
        this.initComponents();
    }

    MetaDataDisplay(GeneralFile generalFile, MetaDataRecordList[] metaDataRecordListArray, String[] stringArray) {
        this.queryObj = generalFile;
        this.rl = metaDataRecordListArray;
        this.action = true;
        this.initComponents();
    }

    MetaDataDisplay(GeneralFile generalFile, MetaDataSelect[] metaDataSelectArray) throws IOException {
        this.queryObj = generalFile;
        this.selects = metaDataSelectArray;
        this.rl = generalFile.query(metaDataSelectArray);
        this.initComponents();
    }

    MetaDataDisplay(GeneralFile generalFile, MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray) throws IOException {
        this.queryObj = generalFile;
        this.conditions = metaDataConditionArray;
        this.selects = metaDataSelectArray;
        this.rl = generalFile.query(metaDataConditionArray, metaDataSelectArray);
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BoxLayout(this, 0));
        if (this.rl != null) {
            this.add((Component)this.createResultsComponent(this.rl), new GridBagConstraints());
        } else if (this.table != null) {
            this.add((Component)MetaDataTableDisplay.createMetaDataTable(this.table), new GridBagConstraints());
        }
        if (this.conditions != null) {
            this.jComboBox1 = new JComboBox();
            this.jPanel2 = new JPanel();
            this.jSeparator1 = new JSeparator();
            this.jScrollPane1 = new JScrollPane();
            this.mainPanel = new JPanel();
            this.mainPanel.add(this.jComboBox1);
            this.mainPanel.add(this.jPanel2);
            this.mainPanel.add(this.jSeparator1);
            this.mainPanel.add(this.jScrollPane1);
            this.add((Component)this.mainPanel, new GridBagConstraints());
        }
        if (this.action) {
            this.jComboBox1 = new JComboBox();
            this.jSeparator1 = new JSeparator();
            this.jPanel2 = new JPanel();
            this.mainPanel = new JPanel();
            this.mainPanel.add(this.jComboBox1);
            this.mainPanel.add(this.jSeparator1);
            this.mainPanel.add(this.jPanel2);
            this.add((Component)this.mainPanel, new GridBagConstraints());
            this.jList1 = new JList();
            this.jButton1 = new JButton();
            this.add(this.jList1);
            this.jButton1.setMinimumSize(new Dimension(40, 25));
            this.add(this.jButton1);
        }
    }

    void setKeyValue(boolean bl) {
        this.keyValue = bl;
    }

    boolean getKeyValue() {
        return this.keyValue;
    }

    JTable createResultsTable(MetaDataRecordList[] metaDataRecordListArray) {
        return this.createResultsTable(metaDataRecordListArray, 0);
    }

    JTable createResultsTable(MetaDataRecordList[] metaDataRecordListArray, int n) {
        String[] stringArray;
        if (metaDataRecordListArray == null) {
            return null;
        }
        int n2 = 0;
        boolean bl = false;
        int n3 = metaDataRecordListArray[0].getFieldCount();
        int n4 = metaDataRecordListArray.length;
        String[] stringArray2 = new String[n3];
        Object[][] objectArray = new Object[n4][n3];
        JTable jTable = null;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n3) {
            switch (metaDataRecordListArray[0].getFieldType(n6)) {
                case 14: {
                    if (this.keyValue) {
                        MetaDataTable metaDataTable = metaDataRecordListArray[0].getTableValue(n6);
                        stringArray = new String[(n5 += n3 + metaDataTable.getRowCount()) - 1];
                        System.arraycopy(stringArray2, 0, stringArray, 0, n3);
                        int n7 = n3;
                        while (n7 < n5) {
                            stringArray[n7 - 1] = metaDataTable.getStringValue(n7 - n3, 0);
                            ++n7;
                        }
                        stringArray2 = stringArray;
                        break;
                    }
                    stringArray2[n6] = metaDataRecordListArray[0].getFieldName(n6);
                    break;
                }
                default: {
                    stringArray2[n6] = metaDataRecordListArray[0].getFieldName(n6);
                }
            }
            ++n6;
        }
        int n8 = 0;
        while (n8 < n4) {
            int n9 = 0;
            while (n9 < n3) {
                if (metaDataRecordListArray[n8].getFieldCount() > n9) {
                    switch (metaDataRecordListArray[n8].getFieldType(n9)) {
                        case 14: {
                            if (this.keyValue) {
                                MetaDataTable metaDataTable = metaDataRecordListArray[n8].getTableValue(n9);
                                Object[] objectArray2 = new Object[n5];
                                System.arraycopy(objectArray[n8], 0, objectArray2, 0, n3);
                                int n10 = n3;
                                while (n10 < n5) {
                                    objectArray2[n10 - 1] = metaDataTable.getStringValue(n10 - n3, 1);
                                    ++n10;
                                }
                                objectArray[n8] = objectArray2;
                                break;
                            }
                            objectArray[n8][n9] = new MetaDataTableDisplay(metaDataRecordListArray[n8].getTableValue(n9));
                            MetaDataTableDisplay cfr_ignored_0 = (MetaDataTableDisplay)objectArray[n8][n9];
                            objectArray[n8][n9] = MetaDataTableDisplay.createMetaDataTable(metaDataRecordListArray[n8].getTableValue(n9));
                            n2 += metaDataRecordListArray[n8].getTableValue(n9).getRowCount();
                            break;
                        }
                        default: {
                            objectArray[n8][n9] = metaDataRecordListArray[n8].getStringValue(n9);
                        }
                    }
                }
                ++n9;
            }
            ++n8;
        }
        if (n2 > 0) {
            jTable = this.displayMetaData(objectArray, stringArray2, metaDataRecordListArray);
        } else {
            jTable = new JTable(new MetaDataTableModel(objectArray, stringArray2)){

                public TableCellEditor getDefaultEditor(Class clazz) {
                    return super.getDefaultEditor(clazz);
                }
            };
            stringArray = jTable.getDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = MetaDataDisplay.class$("java.lang.String")) : class$java$lang$String);
            jTable.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = MetaDataDisplay.class$("java.lang.String")) : class$java$lang$String, new MetaDataTableCellRenderer((TableCellRenderer)stringArray));
            TableCellEditor tableCellEditor = jTable.getDefaultEditor(class$java$lang$String == null ? (class$java$lang$String = MetaDataDisplay.class$("java.lang.String")) : class$java$lang$String);
            jTable.setDefaultEditor(class$java$lang$String == null ? (class$java$lang$String = MetaDataDisplay.class$("java.lang.String")) : class$java$lang$String, new MetaDataTableCellEditor(tableCellEditor));
        }
        if (n2 > 1) {
            int n11 = MetaDataDisplay.initColumnSizes(jTable);
            int n12 = (objectArray.length + 1 + (n2 -= 2)) * fontPixelHeight;
            jTable.setPreferredScrollableViewportSize(new Dimension(n11, n12 * 2));
            jTable.setRowHeight(n12);
        } else {
            int n13 = MetaDataDisplay.initColumnSizes(jTable);
            int n14 = objectArray.length * fontPixelHeight;
            jTable.setPreferredScrollableViewportSize(new Dimension(n13, n14));
            jTable.setRowHeight(n14);
        }
        return jTable;
    }

    JComponent createResultsComponent(MetaDataRecordList[] metaDataRecordListArray) {
        return this.createResultsComponent(metaDataRecordListArray, 0);
    }

    JComponent createResultsComponent(MetaDataRecordList[] metaDataRecordListArray, int n) {
        if (metaDataRecordListArray == null) {
            return null;
        }
        if (n < 0) {
            return this.createResultsTable(metaDataRecordListArray, n);
        }
        JTable jTable = null;
        JScrollPane jScrollPane = new JScrollPane();
        JScrollBar jScrollBar = jScrollPane.createVerticalScrollBar();
        jTable = this.createResultsTable(metaDataRecordListArray, n);
        jScrollBar.setValue(n);
        if (!metaDataRecordListArray[0].isQueryComplete()) {
            // empty if block
        }
        jScrollPane.setVerticalScrollBar(jScrollBar);
        jScrollPane.setViewportView(jTable);
        Dimension dimension = ((Component)jTable).getPreferredSize();
        dimension.setSize(dimension.width, dimension.height + fontPixelHeight + 3);
        jScrollPane.setPreferredSize(dimension);
        jTable.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                int n = tableModelEvent.getFirstRow();
                int n2 = tableModelEvent.getColumn();
                TableModel tableModel = (TableModel)tableModelEvent.getSource();
                String string = tableModel.getColumnName(n2);
                Object object = tableModel.getValueAt(n, n2);
            }
        });
        return jScrollPane;
    }

    static int initColumnSizes(JTable jTable) {
        TableModel tableModel = jTable.getModel();
        TableColumn tableColumn = null;
        int n = jTable.getColumnCount();
        Component component = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 3;
        TableCellRenderer tableCellRenderer = jTable.getTableHeader().getDefaultRenderer();
        int n5 = 0;
        while (n5 < n) {
            tableColumn = jTable.getColumnModel().getColumn(n5);
            component = tableCellRenderer.getTableCellRendererComponent(null, tableColumn.getHeaderValue(), false, false, 0, 0);
            MetaDataDisplay.setupComp(component);
            n2 = component.getPreferredSize().width + 3;
            int n6 = 0;
            int n7 = Math.min(TEST_ROWS, jTable.getRowCount());
            int n8 = 0;
            while (n8 < n7) {
                Object object = jTable.getValueAt(n8, n5);
                n6 = n3;
                if (object == null) {
                    n3 = 1;
                } else if (object instanceof String) {
                    n3 = MetaDataDisplay.getCellWidth(object.toString());
                } else if (object instanceof Integer) {
                    n3 = MetaDataDisplay.getCellWidth(object.toString());
                } else if (object instanceof Long) {
                    n3 = MetaDataDisplay.getCellWidth(object.toString());
                } else if (object instanceof Float) {
                    n3 = MetaDataDisplay.getCellWidth(object.toString());
                } else if (object instanceof Date) {
                    n3 = MetaDataDisplay.getCellWidth(object.toString());
                } else if (object instanceof JTable) {
                    n3 = MetaDataDisplay.initColumnSizes((JTable)object);
                }
                n3 = Math.max(n3, n6);
                ++n8;
            }
            n3 = Math.max(n2, n3);
            tableColumn.setPreferredWidth(n3);
            n4 += n3;
            n3 = 0;
            ++n5;
        }
        return n4;
    }

    private static void setupComp(Component component) {
        if (fontMetrics == null) {
            font = component.getFont();
            if (font == null) {
                font = new Font("SansSerif", 0, 12);
                component.setFont(font);
            }
            fontMetrics = component.getFontMetrics(font);
        }
    }

    private static int getCellWidth(String string) {
        int n = fontMetrics.stringWidth(string);
        if (fontPixelHeight <= 0) {
            fontPixelHeight = fontMetrics.getHeight();
        }
        return n + 3;
    }

    JTable displayMetaData(Object[][] objectArray, String[] stringArray, MetaDataRecordList[] metaDataRecordListArray) {
        JTable jTable = new JTable(new MetaDataTableModel(objectArray, stringArray));
        TableCellRenderer tableCellRenderer = jTable.getDefaultRenderer(class$javax$swing$JTable == null ? (class$javax$swing$JTable = MetaDataDisplay.class$("javax.swing.JTable")) : class$javax$swing$JTable);
        jTable.setDefaultRenderer(class$javax$swing$JTable == null ? (class$javax$swing$JTable = MetaDataDisplay.class$("javax.swing.JTable")) : class$javax$swing$JTable, new MetaDataTableCellRenderer(tableCellRenderer));
        if (this.queryObj != null) {
            TableCellEditor tableCellEditor = jTable.getDefaultEditor(class$javax$swing$JTable == null ? (class$javax$swing$JTable = MetaDataDisplay.class$("javax.swing.JTable")) : class$javax$swing$JTable);
            jTable.setDefaultEditor(class$javax$swing$JTable == null ? (class$javax$swing$JTable = MetaDataDisplay.class$("javax.swing.JTable")) : class$javax$swing$JTable, new MetaDataTableCellEditor(tableCellEditor));
        }
        return jTable;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ MetaDataRecordList[] access$100(MetaDataDisplay metaDataDisplay) {
        return metaDataDisplay.rl;
    }

    static /* synthetic */ GeneralFile access$200(MetaDataDisplay metaDataDisplay) {
        return metaDataDisplay.queryObj;
    }

    class MetaDataTableModel
    extends AbstractTableModel {
        Object[][] data;
        private String[] names;

        MetaDataTableModel(Object[][] objectArray, String[] stringArray) {
            this.data = objectArray;
            this.names = stringArray;
            this.addTableModelListener(new TableModelListener(this){
                private final /* synthetic */ MetaDataTableModel this$1;
                {
                    this.this$1 = metaDataTableModel;
                }

                public void tableChanged(TableModelEvent tableModelEvent) {
                    int n = tableModelEvent.getFirstRow();
                    int n2 = tableModelEvent.getColumn();
                    TableModel tableModel = (TableModel)tableModelEvent.getSource();
                    String string = tableModel.getColumnName(n2);
                    Object object = tableModel.getValueAt(n, n2);
                    System.out.println("~~~~~~~~~tableChanged " + object);
                }
            });
        }

        public String getColumnName(int n) {
            return this.names[n];
        }

        public int getRowCount() {
            return this.data.length;
        }

        public int getColumnCount() {
            return this.names.length;
        }

        public Object getValueAt(int n, int n2) {
            while (n2 >= this.data[n].length) {
                --n2;
            }
            return this.data[n][n2];
        }

        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        public Class getColumnClass(int n) {
            while (n >= this.data[0].length) {
                --n;
            }
            Object object = this.getValueAt(0, n);
            if (object != null) {
                return object.getClass();
            }
            return class$java$lang$String == null ? (class$java$lang$String = MetaDataDisplay.class$("java.lang.String")) : class$java$lang$String;
        }
    }

    class MetaDataTableCellRenderer
    implements TableCellRenderer {
        private TableCellRenderer __defaultRenderer;
        private TableCellEditor defaultEditor;

        public MetaDataTableCellRenderer(TableCellRenderer tableCellRenderer) {
            this.__defaultRenderer = tableCellRenderer;
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object instanceof JComponent) {
                return (JComponent)object;
            }
            return this.__defaultRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    class MetaDataTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private TableCellEditor defaultEditor;
        Object component;
        String originalValue;
        int currentRow = -1;
        int currentColumn = -1;

        public MetaDataTableCellEditor(TableCellEditor tableCellEditor) {
            this.defaultEditor = tableCellEditor;
            this.addCellEditorListener(new CellEditorListener(this){
                private final /* synthetic */ MetaDataTableCellEditor this$1;
                {
                    this.this$1 = metaDataTableCellEditor;
                }

                public void editingCanceled(ChangeEvent changeEvent) {
                }

                public void editingStopped(ChangeEvent changeEvent) {
                    MetaDataRecordList[] metaDataRecordListArray = new MetaDataRecordList[1];
                    System.out.println("editingStopped");
                    try {
                        if (this.this$1.getCellEditorValue() instanceof JTable) {
                            System.out.println("JTable");
                            JTable jTable = (JTable)this.this$1.getCellEditorValue();
                            int n = jTable.getRowCount();
                            int n2 = jTable.getColumnCount();
                            String[][] stringArray = new String[n][n2];
                            int[] nArray = new int[n];
                            Object object = null;
                            int n3 = 0;
                            while (n3 < n) {
                                int n4 = 0;
                                while (n4 < n2) {
                                    object = jTable.getValueAt(n3, n4);
                                    if (object != null) {
                                        stringArray[n3][n4] = object.toString();
                                    }
                                    ++n4;
                                }
                                nArray[n3] = 0;
                                ++n3;
                            }
                            MetaDataTable metaDataTable = new MetaDataTable(nArray, stringArray);
                            metaDataRecordListArray[0] = new SRBMetaDataRecordList(MetaDataDisplay.access$100(MetaDataTableCellEditor.access$000(this.this$1))[this.this$1.currentRow].getField(this.this$1.currentColumn), metaDataTable);
                            MetaDataDisplay.access$200(MetaDataTableCellEditor.access$000(this.this$1)).modifyMetaData(metaDataRecordListArray[0]);
                        } else if (this.this$1.getCellEditorValue() instanceof JTextField) {
                            System.out.println("JTextField " + ((JTextField)this.this$1.component).getText());
                            System.out.println("originalValue " + this.this$1.originalValue);
                            JTextField jTextField = (JTextField)this.this$1.getCellEditorValue();
                            String string = jTextField.getText();
                            if (!string.equals(this.this$1.originalValue)) {
                                System.out.println("rl " + MetaDataDisplay.access$100(MetaDataTableCellEditor.access$000(this.this$1)));
                                Object object = MetaDataDisplay.access$100(MetaDataTableCellEditor.access$000(this.this$1))[this.this$1.currentRow].getValue(this.this$1.currentColumn);
                                System.out.println("um " + object);
                                if (object instanceof MetaDataTable) {
                                    System.out.println("table " + object);
                                    MetaDataDisplay.access$100(MetaDataTableCellEditor.access$000(this.this$1))[this.this$1.currentRow].setValue(this.this$1.currentColumn, (MetaDataTable)object);
                                    metaDataRecordListArray[0] = new SRBMetaDataRecordList(MetaDataDisplay.access$100(MetaDataTableCellEditor.access$000(this.this$1))[this.this$1.currentRow].getField(this.this$1.currentColumn), (MetaDataTable)object);
                                } else {
                                    MetaDataDisplay.access$100(MetaDataTableCellEditor.access$000(this.this$1))[this.this$1.currentRow].setValue(this.this$1.currentColumn, string);
                                    metaDataRecordListArray[0] = new SRBMetaDataRecordList(MetaDataDisplay.access$100(MetaDataTableCellEditor.access$000(this.this$1))[this.this$1.currentRow].getField(this.this$1.currentColumn), string);
                                }
                                MetaDataDisplay.access$200(MetaDataTableCellEditor.access$000(this.this$1)).modifyMetaData(metaDataRecordListArray[0]);
                            }
                        } else if (this.this$1.getCellEditorValue() instanceof String) {
                            System.out.println("getCellEditorValue- String " + this.this$1.getCellEditorValue());
                        }
                        System.out.println(MetaDataDisplay.access$200(MetaDataTableCellEditor.access$000(this.this$1)) + "\n------\n");
                    }
                    catch (SRBException sRBException) {
                        int n = sRBException.getType();
                        System.out.println("Standardized SRB Server Error Type: " + n);
                        String string = sRBException.getStandardMessage();
                        System.out.println("Standardized SRB Server Error Message: " + string);
                        System.out.println("\nJargon Error Message: " + sRBException.getMessage());
                        sRBException.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            });
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (this.defaultEditor != null) {
                this.defaultEditor = null;
            }
            if (this.component != null) {
                this.component = null;
            }
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.component = object;
            this.currentRow = n;
            this.currentColumn = n2;
            if (object instanceof String) {
                this.component = new JTextField((String)object);
                this.originalValue = (String)object;
            } else {
                this.component = this.defaultEditor.getTableCellEditorComponent(jTable, object, bl, n, n2);
            }
            return (Component)this.component;
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public Object getCellEditorValue() {
            return this.component;
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            super.addCellEditorListener(cellEditorListener);
        }

        public void cancelCellEditing() {
            super.cancelCellEditing();
        }

        public boolean isCellEditable(EventObject eventObject) {
            return super.isCellEditable(eventObject);
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            super.removeCellEditorListener(cellEditorListener);
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return super.shouldSelectCell(eventObject);
        }

        public boolean stopCellEditing() {
            return super.stopCellEditing();
        }

        static /* synthetic */ MetaDataDisplay access$000(MetaDataTableCellEditor metaDataTableCellEditor) {
            return metaDataTableCellEditor.MetaDataDisplay.this;
        }
    }

    class MoreQueryAdjustmentListener
    implements AdjustmentListener {
        JScrollBar jScrollBar;
        JScrollPane jScrollPane;
        MetaDataRecordList[] rl;

        MoreQueryAdjustmentListener(JScrollBar jScrollBar) {
            this.jScrollBar = jScrollBar;
        }

        MoreQueryAdjustmentListener(JScrollBar jScrollBar, MetaDataRecordList[] metaDataRecordListArray, JScrollPane jScrollPane) {
            this.jScrollBar = jScrollBar;
            this.rl = metaDataRecordListArray;
            this.jScrollPane = jScrollPane;
        }

        void expandTable(int n) throws IOException {
            if (this.rl[this.rl.length - 1].isQueryComplete()) {
                return;
            }
            MetaDataRecordList[] metaDataRecordListArray = this.rl;
            MetaDataRecordList[] metaDataRecordListArray2 = this.rl[0].getMoreResults();
            int n2 = metaDataRecordListArray2.length;
            int n3 = metaDataRecordListArray.length;
            this.rl = new MetaDataRecordList[n3 + n2];
            System.arraycopy(metaDataRecordListArray, 0, this.rl, 0, n3);
            System.arraycopy(metaDataRecordListArray2, 0, this.rl, n3, n2);
            MetaDataDisplay.this.remove(this.jScrollPane);
            MetaDataDisplay.this.add((Component)MetaDataDisplay.this.createResultsComponent(this.rl), new GridBagConstraints());
            MetaDataDisplay.this.updateUI();
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            block2: {
                int n = this.jScrollBar.getValue();
                if (!((double)n >= (double)this.jScrollBar.getMaximum() * 0.75)) break block2;
                try {
                    this.expandTable(n);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }
}

