/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io;

import edu.sdsc.grid.io.GeneralAccount;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralFileInputStream;
import edu.sdsc.grid.io.GeneralFileOutputStream;
import edu.sdsc.grid.io.GeneralFileSystem;
import edu.sdsc.grid.io.GeneralRandomAccessFile;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.local.LocalFileInputStream;
import edu.sdsc.grid.io.local.LocalFileOutputStream;
import edu.sdsc.grid.io.local.LocalFileSystem;
import edu.sdsc.grid.io.local.LocalRandomAccessFile;
import edu.sdsc.grid.io.srb.SRBAccount;
import edu.sdsc.grid.io.srb.SRBFile;
import edu.sdsc.grid.io.srb.SRBFileInputStream;
import edu.sdsc.grid.io.srb.SRBFileOutputStream;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import edu.sdsc.grid.io.srb.SRBRandomAccessFile;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public final class FileFactory {
    public static GeneralFileSystem newFileSystem(GeneralAccount generalAccount) throws IOException {
        if (generalAccount != null) {
            Class<?> clazz = generalAccount.getClass();
            try {
                if (clazz.equals(Class.forName("edu.sdsc.grid.io.srb.SRBAccount"))) {
                    return new SRBFileSystem((SRBAccount)generalAccount);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return new LocalFileSystem();
    }

    public static GeneralFile newFile(URI uRI) throws IOException {
        if (uRI.getScheme().equals("srb")) {
            return new SRBFile(uRI);
        }
        return new LocalFile(uRI);
    }

    public static GeneralFile newFile(URI uRI, String string) throws IOException {
        int n = -1;
        String string2 = uRI.getUserInfo();
        if (uRI.getScheme().equals("srb")) {
            if (string.indexOf(":") >= 0 || string.indexOf("@") >= 0) {
                throw new IllegalArgumentException("Password contains illegal charaters");
            }
            n = string2.indexOf(":");
            if (n >= 0) {
                string2 = string2.substring(0, n);
            }
            string2 = string2 + ":" + string;
            try {
                uRI = new URI(uRI.getScheme(), string2, uRI.getHost(), uRI.getPort(), uRI.getPath(), "", "");
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException("Password contains illegal charaters");
            }
            return new SRBFile(uRI);
        }
        return new LocalFile(uRI);
    }

    public static GeneralFile newFile(GeneralFileSystem generalFileSystem, String string) {
        if (generalFileSystem != null) {
            Class<?> clazz = generalFileSystem.getClass();
            try {
                if (clazz.equals(Class.forName("edu.sdsc.grid.io.srb.SRBFileSystem"))) {
                    return new SRBFile((SRBFileSystem)generalFileSystem, string);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return new LocalFile(string);
    }

    public static GeneralFile newFile(GeneralFileSystem generalFileSystem, String string, String string2) {
        if (generalFileSystem != null) {
            Class<?> clazz = generalFileSystem.getClass();
            try {
                if (clazz.equals(Class.forName("edu.sdsc.grid.io.srb.SRBFileSystem"))) {
                    return new SRBFile((SRBFileSystem)generalFileSystem, string, string2);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return new LocalFile(string, string2);
    }

    public static GeneralFile newFile(GeneralFile generalFile, String string) {
        if (generalFile != null) {
            Class<?> clazz = generalFile.getClass();
            try {
                if (clazz.equals(Class.forName("edu.sdsc.grid.io.srb.SRBFile"))) {
                    return new SRBFile((SRBFile)generalFile, string);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return new LocalFile((LocalFile)generalFile, string);
    }

    public static GeneralRandomAccessFile newRandomAccessFile(GeneralFile generalFile, String string) throws IOException {
        Class<?> clazz = generalFile.getClass();
        try {
            if (clazz.equals(Class.forName("edu.sdsc.grid.io.srb.SRBFile"))) {
                return new SRBRandomAccessFile((SRBFile)generalFile, string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return new LocalRandomAccessFile((LocalFile)generalFile, string);
    }

    public static GeneralFileInputStream newFileInputStream(GeneralFile generalFile) throws IOException {
        Class<?> clazz = generalFile.getClass();
        try {
            if (clazz.equals(Class.forName("edu.sdsc.grid.io.srb.SRBFile"))) {
                return new SRBFileInputStream((SRBFile)generalFile);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return new LocalFileInputStream((LocalFile)generalFile);
    }

    public static GeneralFileOutputStream newFileOutputStream(GeneralFile generalFile) throws IOException {
        Class<?> clazz = generalFile.getClass();
        try {
            if (clazz.equals(Class.forName("edu.sdsc.grid.io.srb.SRBFile"))) {
                return new SRBFileOutputStream((SRBFile)generalFile);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return new LocalFileOutputStream((LocalFile)generalFile);
    }
}

