/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io;

import edu.sdsc.grid.io.MetaDataField;
import edu.sdsc.grid.io.MetaDataTable;

public final class MetaDataCondition {
    public static final int EQUAL = 0;
    public static final int NOT_EQUAL = 1;
    public static final int LESS_THAN = 2;
    public static final int GREATER_THAN = 3;
    public static final int LESS_OR_EQUAL = 4;
    public static final int GREATER_OR_EQUAL = 5;
    public static final int IN = 6;
    public static final int NOT_IN = 7;
    public static final int BETWEEN = 8;
    public static final int NOT_BETWEEN = 9;
    public static final int LIKE = 10;
    public static final int NOT_LIKE = 11;
    public static final int SOUNDS_LIKE = 12;
    public static final int SOUNDS_NOT_LIKE = 13;
    public static final int SCALAR = 0;
    public static final int RANGEPAIR = 1;
    public static final int ENUM = 2;
    public static final int TABLE = 14;
    MetaDataField field;
    int operator;
    Object[] values;
    int style;
    int type;
    private static String[] operatorStrings = new String[15];

    MetaDataCondition(MetaDataField metaDataField, int n, int n2) {
        if (metaDataField == null) {
            throw new NullPointerException("field cannot be null.");
        }
        this.field = metaDataField;
        this.values = new Object[1];
        this.values[0] = new Integer(n2);
        this.type = 0;
        this.style = 0;
        this.setOperator(n);
    }

    MetaDataCondition(MetaDataField metaDataField, int n, float f) {
        if (metaDataField == null) {
            throw new NullPointerException("field cannot be null.");
        }
        this.field = metaDataField;
        this.values = new Object[1];
        this.values[0] = new Float(f);
        this.type = 2;
        this.style = 0;
        this.setOperator(n);
    }

    MetaDataCondition(MetaDataField metaDataField, int n, String string) {
        if (metaDataField == null) {
            throw new NullPointerException("field cannot be null.");
        }
        this.field = metaDataField;
        this.values = new Object[1];
        this.values[0] = string;
        this.type = 3;
        this.style = 0;
        this.setOperator(n);
    }

    MetaDataCondition(MetaDataField metaDataField, int n, int n2, int n3) {
        if (metaDataField == null) {
            throw new NullPointerException("field cannot be null.");
        }
        this.field = metaDataField;
        this.values = new Object[2];
        this.values[0] = new Integer(n2);
        this.values[1] = new Integer(n3);
        this.type = 0;
        this.style = 1;
        if (n != 8 && n != 9) {
            throw new IllegalArgumentException("Wrong operator.");
        }
        this.operator = n;
    }

    MetaDataCondition(MetaDataField metaDataField, int n, float f, float f2) {
        if (metaDataField == null) {
            throw new NullPointerException("field cannot be null.");
        }
        this.field = metaDataField;
        this.values = new Object[2];
        this.values[0] = new Float(f);
        this.values[1] = new Float(f2);
        this.type = 2;
        this.style = 1;
        if (n != 8 && n != 9) {
            throw new IllegalArgumentException("Wrong operator.");
        }
        this.operator = n;
    }

    MetaDataCondition(MetaDataField metaDataField, int n, String string, String string2) {
        if (metaDataField == null) {
            throw new NullPointerException("field cannot be null.");
        }
        this.field = metaDataField;
        this.values = new Object[2];
        this.values[0] = string;
        this.values[1] = string2;
        this.type = 3;
        this.style = 1;
        if (n != 8 && n != 9) {
            throw new IllegalArgumentException("Wrong operator.");
        }
        this.operator = n;
    }

    MetaDataCondition(MetaDataField metaDataField, int n, int[] nArray) {
        if (metaDataField == null) {
            throw new NullPointerException("field cannot be null.");
        }
        this.field = metaDataField;
        this.values = new Object[nArray.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            this.values[n2] = new Integer(nArray[n2]);
            ++n2;
        }
        this.type = 0;
        this.style = 2;
        if (n != 6 && n != 7) {
            throw new IllegalArgumentException("Wrong operator.");
        }
        this.operator = n;
    }

    MetaDataCondition(MetaDataField metaDataField, int n, float[] fArray) {
        if (metaDataField == null) {
            throw new NullPointerException("field cannot be null.");
        }
        this.field = metaDataField;
        this.values = new Object[fArray.length];
        int n2 = 0;
        while (n2 < fArray.length) {
            this.values[n2] = new Float(fArray[n2]);
            ++n2;
        }
        this.type = 2;
        this.style = 2;
        if (n != 6 && n != 7) {
            throw new IllegalArgumentException("Wrong operator.");
        }
        this.operator = n;
    }

    MetaDataCondition(MetaDataField metaDataField, int n, String[] stringArray) {
        if (metaDataField == null) {
            throw new NullPointerException("field cannot be null.");
        }
        this.field = metaDataField;
        this.values = new Object[stringArray.length];
        this.values = stringArray;
        this.type = 3;
        this.style = 2;
        if (n == 6 || n == 7) {
            this.operator = n;
        }
    }

    MetaDataCondition(MetaDataField metaDataField, MetaDataTable metaDataTable) {
        if (metaDataField == null) {
            throw new NullPointerException("field cannot be null.");
        }
        this.field = metaDataField;
        this.values = new Object[1];
        this.values[0] = metaDataTable;
        this.type = 14;
        this.style = 14;
        this.operator = 14;
    }

    protected void finalize() {
        if (this.field != null) {
            this.field = null;
        }
        if (this.values != null) {
            this.values = null;
        }
    }

    private void setOperator(int n) {
        if (n < 0 || n > 13) {
            throw new IllegalArgumentException("Invalid operator.");
        }
        if (n == 10 || n == 11) {
            String string = this.values[0].toString();
            int n2 = string.indexOf("*");
            while (n2 >= 0) {
                string = string.substring(0, n2) + "%" + string.substring(n2 + 1);
                n2 = string.indexOf("*");
            }
            n2 = string.indexOf("?");
            while (n2 >= 0) {
                string = string.substring(0, n2) + "_" + string.substring(n2 + 1);
                n2 = string.indexOf("?");
            }
            if (string.indexOf("%") < 0 && string.indexOf("_") < 0) {
                string = "%" + string + "%";
            }
            this.values[0] = string;
        }
        this.operator = n;
    }

    public MetaDataField getField() {
        return this.field;
    }

    public String getFieldName() {
        return this.field.getName();
    }

    public int getFieldType() {
        return this.field.getType();
    }

    public int getOperator() {
        return this.operator;
    }

    public int getStyle() {
        return this.style;
    }

    public int getCount() {
        return this.values.length;
    }

    public int getIntValue(int n) {
        if (n < this.values.length && n >= 0) {
            if (this.style == 14) {
                throw new UnsupportedOperationException();
            }
            if (this.type == 0) {
                return (Integer)this.values[n];
            }
            if (this.type == 2) {
                return ((Float)this.values[n]).intValue();
            }
            if (this.type == 3) {
                return new Integer(this.values[n].toString());
            }
        }
        throw new IllegalArgumentException();
    }

    public float getFloatValue(int n) {
        if (n < this.values.length && n >= 0) {
            if (this.style == 14) {
                throw new UnsupportedOperationException();
            }
            if (this.type == 0) {
                return ((Integer)this.values[n]).floatValue();
            }
            if (this.type == 2) {
                return ((Float)this.values[n]).floatValue();
            }
            if (this.type == 3) {
                return new Float(this.values[n].toString()).floatValue();
            }
        }
        throw new IllegalArgumentException();
    }

    public String getStringValue(int n) {
        if (n < this.values.length && n >= 0) {
            if (this.style == 14) {
                throw new UnsupportedOperationException();
            }
            if (this.type == 0) {
                return ((Integer)this.values[n]).toString();
            }
            if (this.type == 2) {
                return ((Float)this.values[n]).toString();
            }
            if (this.type == 3) {
                if (this.values[n] == null) {
                    return "";
                }
                return this.values[n].toString();
            }
        }
        throw new IllegalArgumentException();
    }

    public int getIntValue() {
        return this.getIntValue(0);
    }

    public float getFloatValue() {
        return this.getFloatValue(0);
    }

    public String getStringValue() {
        return this.getStringValue(0);
    }

    public MetaDataTable getTableValue() {
        if (this.style != 14) {
            throw new UnsupportedOperationException();
        }
        return (MetaDataTable)this.values[0];
    }

    public String toString() {
        String string = new String(this.field.getName());
        string = string + " " + MetaDataCondition.getOperatorString(this.operator);
        int n = 0;
        while (n < this.values.length) {
            string = string + " " + this.values[n];
            ++n;
        }
        return string;
    }

    public boolean equals(Object object) {
        try {
            if (object == null) {
                return false;
            }
            MetaDataCondition metaDataCondition = (MetaDataCondition)object;
            if (this.getField().equals(metaDataCondition.getField()) && this.getOperator() == metaDataCondition.getOperator()) {
                int n = 0;
                while (n < this.values.length) {
                    if (!this.values[n].equals(metaDataCondition.values[n])) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return false;
    }

    public static String getOperatorString(int n) {
        if (n < 0 || n >= operatorStrings.length) {
            throw new IllegalArgumentException();
        }
        return operatorStrings[n];
    }

    public static String[] getOperatorStrings() {
        return operatorStrings;
    }

    static {
        MetaDataCondition.operatorStrings[0] = "=";
        MetaDataCondition.operatorStrings[1] = "<>";
        MetaDataCondition.operatorStrings[2] = "<";
        MetaDataCondition.operatorStrings[3] = ">";
        MetaDataCondition.operatorStrings[4] = ">=";
        MetaDataCondition.operatorStrings[5] = "<=";
        MetaDataCondition.operatorStrings[6] = "in";
        MetaDataCondition.operatorStrings[7] = "not in";
        MetaDataCondition.operatorStrings[8] = "between";
        MetaDataCondition.operatorStrings[9] = "not between";
        MetaDataCondition.operatorStrings[10] = "like";
        MetaDataCondition.operatorStrings[11] = "not like";
        MetaDataCondition.operatorStrings[12] = "sounds like";
        MetaDataCondition.operatorStrings[13] = "sounds not like";
        MetaDataCondition.operatorStrings[14] = "TABLE";
    }
}

