/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.srb;

import edu.sdsc.grid.io.RemoteAccount;
import edu.sdsc.grid.io.local.LocalFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;

public class SRBAccount
extends RemoteAccount {
    public static final int PASSWD_AUTH = 48;
    public static final int GSI_AUTH = 51;
    public static final int ENCRYPT1 = 53;
    public static final int GSI_DELEGATE = 54;
    public static final String SRB_VERSION_3_3 = "SRB-3.3&G";
    public static final String SRB_VERSION_3_0_2 = "SRB-3.0.2&F";
    public static final String SRB_VERSION_3 = "SRB-3.0.0&E";
    public static final String SRB_VERSION_2 = "SRB2.0.0&D";
    public static final String SRB_VERSION_1_1_8 = "SRB1.1.8&C";
    protected String proxyUserName;
    protected String proxyDomainName;
    protected String domainName;
    protected String defaultStorageResource;
    protected int options = 53;
    protected String proxyMcatZone;
    protected String clientMcatZone;
    protected String execFile;
    protected String certificateAuthority;
    protected static String version = "SRB-3.0.2&F";
    static HashMap versionInt = new HashMap(6, 1.0f);

    public SRBAccount() throws FileNotFoundException, IOException {
        super("", 0, "", "", "");
        LocalFile localFile = new LocalFile(System.getProperty("user.home") + "/.srb/");
        if (!localFile.exists()) {
            localFile = new LocalFile(System.getProperty("user.home") + "/srb/");
        }
        if (!localFile.exists()) {
            throw new FileNotFoundException("Cannot find default srb account info");
        }
        this.setUserInfo(localFile);
    }

    public SRBAccount(String string) throws FileNotFoundException, IOException {
        this(new LocalFile(string));
    }

    public SRBAccount(LocalFile localFile) throws FileNotFoundException, IOException {
        super("", 0, "", "", "");
        if (localFile.equals(null)) {
            throw new NullPointerException("UserInfoDirectory cannot be null");
        }
        this.setUserInfo(localFile);
    }

    public SRBAccount(File file) throws FileNotFoundException, IOException {
        this(new LocalFile(file));
    }

    public SRBAccount(String string, int n, String string2, String string3, String string4, String string5, String string6) {
        super(string, n, string2, string3, string4);
        this.setProxyUserName(string2);
        this.setProxyDomainName(string5);
        this.setDomainName(string5);
        this.setDefaultStorageResource(string6);
    }

    public SRBAccount(String string, int n, String string2, String string3, String string4, String string5, String string6, String string7) {
        super(string, n, string2, string3, string4);
        this.setProxyUserName(string2);
        this.setProxyDomainName(string5);
        this.setDomainName(string5);
        this.setDefaultStorageResource(string6);
        this.setProxyMcatZone(string7);
        this.setMcatZone(string7);
    }

    protected void finalize() {
        super.finalize();
        this.proxyUserName = null;
        this.proxyDomainName = null;
        this.domainName = null;
        this.defaultStorageResource = null;
    }

    public void setHomeDirectory(String string) {
        if (string == null) {
            throw new NullPointerException("The home directory string cannot be null");
        }
        this.homeDirectory = string;
    }

    protected void setProxyUserName(String string) {
        if (string == null) {
            throw new NullPointerException("The proxy user name cannot be null");
        }
        this.proxyUserName = string;
    }

    protected void setProxyDomainName(String string) {
        if (string == null) {
            throw new NullPointerException("The proxy domain name cannot be null");
        }
        this.proxyDomainName = string;
    }

    public void setDomainName(String string) {
        if (string == null) {
            throw new NullPointerException("The domain name cannot be null");
        }
        this.domainName = string;
    }

    public void setDefaultStorageResource(String string) {
        if (string == null) {
            throw new NullPointerException("The default storage resource cannot be null");
        }
        this.defaultStorageResource = string;
    }

    public void setOptions(int n) {
        this.options = n;
    }

    public static void setVersion(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Invalid version");
        }
        if (!(string.equals(SRB_VERSION_1_1_8) || string.equals(SRB_VERSION_2) || string.equals(SRB_VERSION_3) || string.equals(SRB_VERSION_3_0_2) || string.equals(SRB_VERSION_3_3))) {
            throw new IllegalArgumentException("Invalid version");
        }
        version = string;
    }

    public void setProxyMcatZone(String string) {
        this.proxyMcatZone = string;
    }

    public void setMcatZone(String string) {
        this.clientMcatZone = string;
    }

    public void setExecFile(String string) {
        this.execFile = string;
    }

    public void setCertificateAuthority(String string) {
        this.certificateAuthority = string;
    }

    protected String getProxyUserName() {
        return this.proxyUserName;
    }

    protected String getProxyDomainName() {
        return this.proxyDomainName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getDefaultStorageResource() {
        return this.defaultStorageResource;
    }

    public int getOptions() {
        return this.options;
    }

    public static String getVersion() {
        return version;
    }

    static float getVersionNumber() {
        return ((Float)versionInt.get(version)).floatValue();
    }

    public String getProxyMcatZone() {
        return this.proxyMcatZone;
    }

    public String getMcatZone() {
        return this.clientMcatZone;
    }

    public String getExecFile() {
        return this.execFile;
    }

    public String getCertificateAuthority() {
        return this.certificateAuthority;
    }

    public boolean equals(Object object) {
        try {
            if (object == null) {
                return false;
            }
            SRBAccount sRBAccount = (SRBAccount)object;
            if (!this.getHost().equals(sRBAccount.getHost())) {
                return false;
            }
            if (this.getPort() != sRBAccount.getPort()) {
                return false;
            }
            if (!this.getUserName().equals(sRBAccount.getUserName())) {
                return false;
            }
            if (!this.getPassword().equals(sRBAccount.getPassword())) {
                return false;
            }
            if (!this.getProxyUserName().equals(sRBAccount.getProxyUserName())) {
                return false;
            }
            if (!this.getProxyDomainName().equals(sRBAccount.getProxyDomainName())) {
                return false;
            }
            if (!this.getDomainName().equals(sRBAccount.getDomainName())) {
                return false;
            }
            return SRBAccount.getVersion().equals(SRB_VERSION_2) || SRBAccount.getVersion().equals(SRB_VERSION_1_1_8) || this.getProxyMcatZone().equals(sRBAccount.getProxyMcatZone()) || this.getMcatZone().equals(sRBAccount.getMcatZone());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public void setUserInfo(LocalFile localFile) throws FileNotFoundException, IOException {
        LocalFile localFile2 = new LocalFile(localFile, ".MdasEnv");
        if (!localFile2.exists()) {
            localFile2 = new LocalFile(localFile, "MdasEnv");
        }
        this.setMdasUserInfo(localFile2);
        localFile2 = new LocalFile(localFile, ".MdasAuth");
        if (!localFile2.exists()) {
            localFile2 = new LocalFile(localFile, "MdasAuth");
        }
        this.readMdasAuth(localFile2);
    }

    private void setMdasUserInfo(LocalFile localFile) throws FileNotFoundException, IOException {
        int n = 0;
        FileReader fileReader = null;
        fileReader = new FileReader(localFile.getFile());
        char[] cArray = new char[(int)localFile.length()];
        fileReader.read(cArray);
        String string = new String(cArray);
        while (n >= 0) {
            if ((n = string.indexOf("#", n)) < 0) continue;
            string = string.substring(0, n) + string.substring(string.indexOf(10, n + 1), string.length());
        }
        n = string.indexOf("srbHost");
        if (n < 0) {
            throw new NullPointerException("No host name found in Mdas file.");
        }
        n = string.indexOf(39, n) + 1;
        this.setHost(string.substring(n, string.indexOf(39, n)));
        n = string.indexOf("srbPort");
        if (n < 0) {
            this.setPort(5544);
        } else {
            n = string.indexOf(39, n) + 1;
            this.setPort(Integer.parseInt(string.substring(n, string.indexOf(39, n))));
        }
        n = string.indexOf("srbUser");
        if (n < 0) {
            throw new NullPointerException("No user name found in Mdas file.");
        }
        n = string.indexOf(39, n) + 1;
        this.setProxyUserName(string.substring(n, string.indexOf(39, n)));
        this.setUserName(this.proxyUserName);
        n = string.indexOf("mdasDomainHome");
        if (n < 0) {
            throw new NullPointerException("No home domain name found in Mdas file.");
        }
        n = string.indexOf(39, n) + 1;
        this.setProxyDomainName(string.substring(n, string.indexOf(39, n)));
        this.setDomainName(this.proxyDomainName);
        n = string.indexOf("defaultResource");
        if (n < 0) {
            throw new NullPointerException("No default resource found in Mdas file.");
        }
        n = string.indexOf(39, n) + 1;
        this.setDefaultStorageResource(string.substring(n, string.indexOf(39, n)));
        n = string.indexOf("AUTH_SCHEME");
        if (n >= 0) {
            String string2 = null;
            string2 = string.substring(n = string.indexOf(39, n) + 1, string.indexOf(39, n));
            if (string2.equals("PASSWD_AUTH")) {
                this.setOptions(48);
            } else if (string2.equals("GSI_AUTH")) {
                this.setOptions(51);
            } else if (string2.equals("ENCRYPT1")) {
                this.setOptions(53);
            } else {
                if (string2.equals("SEA_AUTH")) {
                    throw new IllegalArgumentException("SEA_AUTH not supported");
                }
                if (string2.equals("SEA_ENCRYPT")) {
                    throw new IllegalArgumentException("SEA_ENCRYPT not supported");
                }
                if (string2.equals("GSI_SECURE_COMM")) {
                    throw new IllegalArgumentException("GSI_SECURE_COMM not supported");
                }
            }
        }
        n = string.indexOf("mcatZone");
        if (n >= 0) {
            n = string.indexOf(39, n) + 1;
            this.setProxyMcatZone(string.substring(n, string.indexOf(39, n)));
        }
        this.setMcatZone(this.proxyMcatZone);
        n = string.indexOf("execFile");
        if (n >= 0) {
            n = string.indexOf(39, n) + 1;
            this.setDefaultStorageResource(string.substring(n, string.indexOf(39, n)));
        }
        if ((n = string.indexOf("mdasCollectionHome")) < 0) {
            if (this.proxyMcatZone == null) {
                this.setHomeDirectory("/" + this.proxyMcatZone + "/" + "home" + "/" + this.userName + "." + this.domainName);
            } else {
                this.setHomeDirectory("/home/" + this.userName + "." + this.domainName);
            }
        } else {
            n = string.indexOf(39, n) + 1;
            this.setHomeDirectory(string.substring(n, string.indexOf(39, n)));
        }
    }

    private void readMdasAuth(LocalFile localFile) throws FileNotFoundException, IOException {
        FileReader fileReader = new FileReader(localFile.getFile());
        char[] cArray = new char[(int)localFile.length()];
        fileReader.read(cArray);
        String string = new String(cArray);
        StringTokenizer stringTokenizer = new StringTokenizer(string, System.getProperty("line.separator") + "\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("#")) continue;
            int n = string2.indexOf(System.getProperty("line.separator")) + string2.indexOf("\n") + 1;
            string = n >= 0 ? string2.substring(0, n) : string2;
        }
        this.setPassword(string);
    }

    static {
        versionInt.put(SRB_VERSION_3_3, new Float(3.3));
        versionInt.put(SRB_VERSION_3_0_2, new Float(3.0f));
        versionInt.put(SRB_VERSION_2, new Float(2.0f));
        versionInt.put(SRB_VERSION_1_1_8, new Float(1.0f));
    }
}

