/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.swing.JideLabel;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.LabelUI;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;

public class BasicJideLabelUI
extends BasicLabelUI {
    private static final LabelUI INSTANCE = new BasicJideLabelUI();
    private static Rectangle paintIconR = new Rectangle();
    private static Rectangle paintTextR = new Rectangle();
    private static Rectangle paintViewR = new Rectangle();
    private static Insets paintViewInsets = new Insets(0, 0, 0, 0);

    public static ComponentUI createUI(JComponent c) {
        return INSTANCE;
    }

    protected void installDefaults(JLabel c) {
        super.installDefaults(c);
        LookAndFeel.installColorsAndFont(c, "JideLabel.background", "JideLabel.foreground", "JideLabel.font");
    }

    public Dimension getMinimumSize(JComponent c) {
        Dimension d = super.getMinimumSize(c);
        if (JideSwingUtilities.getOrientationOf(c) == 0) {
            return d;
        }
        return new Dimension(d.height, d.width);
    }

    public Dimension getMaximumSize(JComponent c) {
        Dimension d = super.getMaximumSize(c);
        if (JideSwingUtilities.getOrientationOf(c) == 0) {
            return d;
        }
        return new Dimension(d.height, d.width);
    }

    public Dimension getPreferredSize(JComponent c) {
        Dimension d = super.getPreferredSize(c);
        if (JideSwingUtilities.getOrientationOf(c) == 0) {
            return d;
        }
        return new Dimension(d.height, d.width);
    }

    public void paint(Graphics g, JComponent c) {
        if (JideSwingUtilities.getOrientationOf(c) == 1) {
            boolean clockwise = true;
            if (c instanceof JideLabel) {
                clockwise = ((JideLabel)c).isClockwise();
            }
            this.paintVertically(g, c, clockwise);
        } else {
            super.paint(g, c);
        }
    }

    public void paintVertically(Graphics g, JComponent c, boolean clockwise) {
        Icon icon;
        JLabel label = (JLabel)c;
        String text = label.getText();
        Icon icon2 = icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        if (icon == null && text == null) {
            return;
        }
        FontMetrics fm = g.getFontMetrics();
        paintViewInsets = c.getInsets(paintViewInsets);
        BasicJideLabelUI.paintViewR.x = BasicJideLabelUI.paintViewInsets.left;
        BasicJideLabelUI.paintViewR.y = BasicJideLabelUI.paintViewInsets.top;
        BasicJideLabelUI.paintViewR.height = c.getWidth() - (BasicJideLabelUI.paintViewInsets.left + BasicJideLabelUI.paintViewInsets.right);
        BasicJideLabelUI.paintViewR.width = c.getHeight() - (BasicJideLabelUI.paintViewInsets.top + BasicJideLabelUI.paintViewInsets.bottom);
        BasicJideLabelUI.paintIconR.height = 0;
        BasicJideLabelUI.paintIconR.width = 0;
        BasicJideLabelUI.paintIconR.y = 0;
        BasicJideLabelUI.paintIconR.x = 0;
        BasicJideLabelUI.paintTextR.height = 0;
        BasicJideLabelUI.paintTextR.width = 0;
        BasicJideLabelUI.paintTextR.y = 0;
        BasicJideLabelUI.paintTextR.x = 0;
        String clippedText = this.layoutCL(label, fm, text, icon, paintViewR, paintIconR, paintTextR);
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform tr = g2.getTransform();
        if (clockwise) {
            g2.rotate(1.5707963267948966);
            g2.translate(0, -c.getWidth());
        } else {
            g2.rotate(-1.5707963267948966);
            g2.translate(-c.getHeight(), 0);
        }
        if (icon != null) {
            icon.paintIcon(c, g, BasicJideLabelUI.paintIconR.x, BasicJideLabelUI.paintIconR.y);
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, paintTextR);
            } else {
                int textX = BasicJideLabelUI.paintTextR.x;
                int textY = BasicJideLabelUI.paintTextR.y + fm.getAscent();
                if (label.isEnabled()) {
                    this.paintEnabledText(label, g, clippedText, textX, textY);
                } else {
                    this.paintDisabledText(label, g, clippedText, textX, textY);
                }
            }
        }
        g2.setTransform(tr);
    }

    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        if ("orientation" == e.getPropertyName()) {
            if (e.getSource() instanceof JLabel) {
                JLabel label = (JLabel)e.getSource();
                label.revalidate();
            }
        } else if ("clockwise".equals(e.getPropertyName()) && e.getSource() instanceof JLabel) {
            JLabel label = (JLabel)e.getSource();
            label.repaint();
        }
    }
}

